import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/dimensions.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/style.dart';

class HistoryStatusSection extends StatelessWidget {
  final String status;
  final bool isDepositAvailable;

  const HistoryStatusSection({Key? key, required this.status, required this.isDepositAvailable}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return IntrinsicWidth(
      child: Container(
        /*padding: const EdgeInsets.symmetric(vertical: Dimensions.space5, horizontal: Dimensions.space10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(5),
            border: Border.all(
                color: status == "1"
                    ? MyColor.colorGreen.withOpacity(.3)
                    : status == "2"
                        ? Colors.orangeAccent.withOpacity(.3)
                        : status == "3"
                            ? Colors.red.withOpacity(0.3)
                            : status == "0" && isDepositAvailable
                                ? MyColor.colorGrey.withOpacity(.1)
                                : Colors.red.withOpacity(0.3),
                width: .5),
            color: status == "1"
                ? MyColor.colorGreen.withOpacity(.1)
                : status == "2"
                    ? Colors.orangeAccent.withOpacity(.1)
                    : status == "3"
                        ? Colors.red.withOpacity(0.2)
                        : status == "0" && isDepositAvailable
                            ? MyColor.colorGrey.withOpacity(.1)
                            : Colors.red.withOpacity(.2)),*/
        child: Text(
          status == "1"
              ? MyStrings.complete.tr
              : status == "2"
                  ? MyStrings.pending.tr
                  : status == "3"
                      ? MyStrings.rejected.tr
                      : status == "0" && isDepositAvailable
                          ? MyStrings.initiated.tr
                          : MyStrings.yetToPay.tr,
          textAlign: TextAlign.center,
          softWrap: false,
          style: mediumDefault.copyWith(
            color: status == "1"
                ? MyColor.colorGreen
                : status == "2"
                    ? Colors.orangeAccent
                    : status == "3"
                        ? Colors.red
                        : status == "0" && isDepositAvailable
                            ? MyColor.primaryColor
                            : Colors.red,
          ),
        ),
      ),
    );
  }
}
